import { http } from '@inside-library/helpers/Http'

export default {
  newsCategories: {
    add: async ({ data }) => {
      const { data: category } = await http.get('content/news_categories', {
        fields: ['uuid', 'exclude_from_listing'],
        filters: {
          'status:eq': 1,
          'uuid:eq': data.uuid
        }
      })

      return {
        name: category?.[0]?.exclude_from_listing
          ? 'CseNewsListingPage'
          : 'NewsListingPage',
        query: { news_categories: data.uuid }
      }
    },
    delete: () => ({ name: 'NewsListingPage' })
  },
  newsletterDaily: {
    add: ({ data }) => {
      return {
        name: 'AdminMailingsPreviewPage',
        params: { uuid: data.uuid }
      }
    },
    delete: () => ({
      name: 'AdminMailingsListPage'
    })
  },
  newsletterWeekly: {
    add: ({ data }) => {
      return {
        name: 'AdminMailingsPreviewPage',
        params: { uuid: data.uuid }
      }
    },
    delete: () => ({
      name: 'AdminMailingsListPage'
    })
  },
  spaces: {
    add: ({ data }) => ({
      name: 'SpacePage',
      params: { slug: data.slug[0] }
    }),
    delete: () => ({
      name: 'SpacesListingPage'
    })
  },
  pagesCategories: {
    add: async ({ data }) => {
      const { data: pagesCategories } = await http.get(
        'content/pages_categories',
        {
          fields: [
            'uuid',
            'slug',
            {
              spaces: {
                fields: ['uuid', 'title', 'slug']
              }
            }
          ],
          filters: {
            'status:eq': 1,
            'uuid:eq': data.uuid
          }
        }
      )

      return {
        name: 'TabSpacePage',
        params: {
          slug: pagesCategories[0].spaces.slug[0]
        }
      }
    },
    delete: async ({ uuid }) => {
      const { data: pagesCategories } = await http.get(
        'content/pages_categories',
        {
          fields: [
            'uuid',
            {
              spaces: {
                fields: ['uuid', 'title', 'slug']
              }
            }
          ],
          filters: {
            'status:eq': 1,
            'uuid:eq': uuid
          }
        }
      )

      return {
        name: 'TabSpacePage',
        params: {
          slug: pagesCategories[0].spaces.slug[0]
        }
      }
    },
    globalSearch: async ({ data }) => {
      const { data: pagesCategories } = await http.get(
        'content/pages_categories',
        {
          fields: ['uuid', { spaces: ['uuid', 'title', 'slug'] }],
          filters: { 'status:eq': 1, 'uuid:eq': data.uuid }
        }
      )

      return {
        route: {
          name: 'TabSpacePage',
          params: {
            slug: pagesCategories[0].spaces.slug[0]
          }
        }
      }
    }
  },
  spacesPages: {
    add: async ({ data }) => {
      const { data: spacesPages } = await http.get('content/spaces_pages', {
        fields: [
          'uuid',
          'slug',
          {
            pages_categories: [
              'uuid',
              'title',
              {
                spaces: {
                  fields: ['uuid', 'title', 'slug']
                }
              }
            ]
          }
        ],
        filters: {
          'status:eq': 1,
          'uuid:eq': data.uuid
        }
      })

      if (spacesPages.length > 0) {
        return {
          name: 'TabSpacePage',
          params: {
            slug: spacesPages[0].pages_categories.spaces.slug[0]
          },
          query: { page: data.uuid }
        }
      }

      return {
        name: 'HomePage'
      }

    },
    delete: async ({ uuid }) => {
      const { data: spacesPages } = await http.get('content/spaces_pages', {
        fields: [
          'uuid',
          'title',
          {
            pages_categories: [
              'uuid',
              'title',
              {
                spaces: {
                  fields: ['uuid', 'title', 'slug']
                }
              }
            ]
          }
        ],
        filters: {
          'status:eq': 1,
          'uuid:eq': uuid
        }
      })

      return {
        name: 'TabSpacePage',
        params: {
          slug: spacesPages[0].pages_categories.spaces.slug[0]
        }
      }
    },
    globalSearch: async ({ data }) => {
      const { data: spacesPages } = await http.get('content/spaces_pages', {
        fields: [
          'uuid',
          'title',
          {
            pages_categories: [
              'uuid',
              'title',
              {
                spaces: {
                  fields: ['uuid', 'title', 'slug']
                }
              }
            ]
          }
        ],
        filters: { 'uuid:eq': data.uuid }
      })

      return {
        route: {
          name: 'TabSpacePage',
          params: {
            slug: spacesPages[0].pages_categories.spaces.slug[0]
          },
          query: { page: data.uuid }
        }
      }
    }
  }
}
