export default {
  users: {
    extendedUrl: ['uuid'],
    modalFields: [
      'uuid',
      'firstname',
      'lastname',
      'function',
      'email',
      'image',
      'phone',
      'mobile_phone',
      'link_teams',
      'ip',
      'service_code',
      'address',
      'zip_code',
      'location',
      { regions: ['uuid', 'title'] },
      { cities: ['uuid', 'title'] },
      { services: ['uuid', 'title'] }
    ]
  },
  documents: {
    extendedUrl: ['uuid'],
    modalFields: [
      'uuid',
      'title',
      'content_type',
      'admin',
      'content',
      'published_at',
      'updated_at',
      'file',
      'image',
      { folders: ['title', 'uuid'] },
      { authors: ['uuid', 'firstname', 'lastname'] }
    ]
  },
  groups_documents: {
    extendedUrl: ['uuid'],
    modalFields: [
      'uuid',
      'title',
      'content_type',
      'admin',
      'content',
      'published_at',
      'updated_at',
      'file',
      'image',
      { folders: ['title', 'uuid'] },
      { authors: ['uuid', 'firstname', 'lastname'] }
    ]
  },
  jobs_offers: {
    modalFields: [
      'uuid',
      'title',
      'content_type',
      'admin',
      'content',
      'published_at',
      'application_date',
      'start_date',
      'end_date',
      { regions: ['uuid', 'title'] },
      { services: ['uuid', 'title'] },
      { contracts_types: ['uuid', 'title'] },
      { cities: ['uuid', 'title'] }
    ]
  },
  markers: {
    modalFields: [
      'uuid',
      'title',
      'content_type',
      'admin',
      'content',
      'covered_area',
      'phone',
      'image',
      'address',
      { regions: ['uuid', 'title'] }
    ]
  }
}
