<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;
use Illuminate\Support\Facades\Artisan;

class FixMarkerType extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $this->migrateContent('marker');

        $this->finishUp();

        $markers = type_to_class('marker')::all();

        $markers->unsearchable();

        $markers->searchable();
    }
}
