<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

final class AddRegionsToSpaces extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->getBridge()?->contentTypeCreateOrUpdateField(
            type: 'spaces',
            fieldName: 'regions',
            options:         [
            'name' => 'regions',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 4,
            'title' => [
              'fr' => 'Région(s)',
              'en' => 'Regions',
            ],
            'description' => [
              'fr' => 'Choix de la (ou des) régions à remonter sur l\'espace',
              'en' => 'Choice of the regions to be uploaded in space',
            ],
            'widget' => [
              'type' => BridgeContentType::SELECT_WIDGET,
              'settings' => [],
              'weight' => 4,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
              'target_type' => ['regions'],
              'cardinality' => -1,
            ],
            'selectable_all' => true,
      ],
            weight: 4,
        );
        $this->finishUp();
    }
}
