<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContent;
use Inside\Content\Models\Contents\NewsCategories;
use Inside\Content\Models\Contents\News;

class MoveSomeContentsToAnotherCategory extends Migration
{
    public function up(): void
    {
        collect(['Direction générale' => 'L\'Agence', 'Appointments' => 'Nominations'])
            ->each(fn ($destinationCategory, $sourceCategory) => $this->moveContentsFromCategoryToAnother($sourceCategory, $destinationCategory, 'fr'));
    }

    public function moveContentsFromCategoryToAnother(string $sourceCategoryTitle, string $destinationCategoryTitle, string $langcode): void
    {
        $bridge = new BridgeContent();
        $sourceCategoryUuid = NewsCategories::where('title', $sourceCategoryTitle)->where('langcode', $langcode)->first()->uuid;
        News::whereHas(
            'newsCategories',
            fn ($query) =>
            $query->where('uuid', $sourceCategoryUuid)
        )
            ->where('langcode', $langcode)
            ->each(function ($content) use ($bridge, $sourceCategoryUuid, $destinationCategoryTitle) {
                $newCategories = $content->newsCategories->where('uuid', '!=', $sourceCategoryUuid)->pluck('uuid')->all();
                $newCategories[] = NewsCategories::where('title', $destinationCategoryTitle)->first()->uuid;
                $bridge->contentUpdate(
                    'news',
                    ['uuid' => $content->uuid, 'news_categories' => $newCategories]
                );
            });
    }
}
