<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Illuminate\Support\Facades\Artisan;

class CreateExcludeFromListingFieldInNewsCategories extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();
        $fields = collect([
            'exclude_from_listing' => [
                'fr' => "Exclure la catégorie du listing principal",
                'en' => "Exclude category from main listing",
                'weight' => 4,
            ],
            'exclude_from_homepage' => [
                'fr' => "Exclure la catégorie de la page d'accueil",
                'en' => "Exclude category from homepage",
                'weight' => 5
            ]
        ]);

        $fields->each(fn (array $data, string $fieldName) => $bridge->contentTypeCreateOrUpdateField(
            type:'news_categories',
            fieldName: $fieldName,
            options: [
                'name' => $fieldName,
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'search_filter' => false,
                'required' => false,
                'weight' => $data['weight'],
                'title' => [
                    'fr' => $data['fr'],
                    'en' => $data['en'],
                ],
                'widget' => [
                    'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                    'settings' => [
                        'display_label' => true,
                    ],
                    'weight' => $data['weight'],
                ],
                'type' => BridgeContentType::BOOLEAN_FIELD,
                'settings' => [
                    'cardinality' => 1,
                ],
                'default' => false,
            ],
            weight: $data['weight']
        ));

        Artisan::call("models:rebuild");
    }

    public function down(): void
    {
    }
}
