<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Content\Models\Contents\Custom;
use Inside\Host\Bridge\BridgeContent;

class CreateQuizCustomPage extends Migration
{
    private ?BridgeContent $bridgeContent = null;

    private function getBridge(): BridgeContent
    {
        return $this->bridgeContent ??= new BridgeContent();
    }

    public function up(): void
    {
        Artisan::call('models:rebuild');

        $custom = [
            'title' => 'Quiz',
            'custom_slug' => 'quiz',
            'redirection_page' => 'QuizListingPage',
        ];

        $locale = config('app.locale');

        $original = Custom::findOrFail($this->createCustom($custom, $locale));

        collect(list_languages())
            ->reject($locale)
            ->each(fn (string $language) => $this->createCustom($custom, $language, $original));
    }

    public function createCustom(array $data, string $langcode, ?Custom $original = null): ?string
    {
        $data['langcode'] = $langcode;

        if ($original instanceof Custom) {
            $data['uuid_host'] = $original->uuid_host;
        }

        $custom = Custom::query()
            ->where('custom_slug', $data['custom_slug'])
            ->where('redirection_page', $data['redirection_page'])
            ->where('langcode', $langcode)
            ->first();

        if ($custom instanceof Custom) {
            $data['uuid'] = $custom->uuid;
        }

        return $this->getBridge()->contentInsert('custom', $data, ! isset($data['uuid']), true);
    }
}
