<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Content\Models\Contents\Cities;
use Inside\Content\Models\Contents\ContractsTypes;
use Inside\Content\Models\Contents\Regions;
use Inside\Content\Models\Contents\Services;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Migrations\CreateContentTypes;

class AddCodeToContentTypes extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->migrateContent('cities');
        $this->migrateContent('services');
        $this->migrateContent('regions');
        $this->migrateContent('contracts_types');
        $this->finishUp();

        $bridge = new BridgeContent();

        Cities::all()->each(fn (Cities $city) => $bridge->contentUpdate('cities', [
            'uuid' => $city->uuid,
            'code' => $city->title,
        ]));

        Services::all()->each(fn (Services $service) => $bridge->contentUpdate('services', [
            'uuid' => $service->uuid,
            'code' => $service->title,
        ]));

        Regions::all()->each(fn (Regions $region) => $bridge->contentUpdate('regions', [
            'uuid' => $region->uuid,
            'code' => $region->title,
        ]));

        ContractsTypes::all()->each(fn (ContractsTypes $contractType) => $bridge->contentUpdate('contracts_types', [
            'uuid' => $contractType->uuid,
            'code' => $contractType->title,
        ]));
    }
}
