<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

final class AddUsersContractsTypes extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->getBridge()?->contentTypeCreateOrUpdateField(
            type: 'users',
            fieldName: 'contracts_types',
            options: [
                'name' => 'contracts_types',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => true,
                'required' => false,
                'title' => [
                    'fr' => 'Type de contrat',
                    'en' => 'Type of Contract',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['contracts_types'],
                    'cardinality' => -1,
                ],
            ],
        );
        $this->finishUp();
    }
}
