<?php

declare(strict_types=1);

use Illuminate\Support\Facades\Artisan;
use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

final class EnableAlphabetFeature extends Migration
{
    public function up(): void
    {
        $bridgeContentType = new BridgeContentType();
        $bridgeContentType->updateContentTypeOptions('alphabet_books', [
            'listing_type' => 'content',
        ]);

        Artisan::call('db:seed', [
            '--class' => 'Inside\\Content\\Seeders\\AlphabetCategoriesSeeder',
        ]);
    }
}
