<?php

use Illuminate\Console\Scheduling\Schedule;
use Inside\Newsletters\Jobs\CreateScheduledNewsletter;

return [
    'schedule' => [
        'create_newsletter_bat' => fn (Schedule $scheduler) => $scheduler
            ->command('inside:newsletter:scheduled:create newsletter_bat')
            ->weekdays()
            ->at('14:55')
            ->timezone('Europe/Paris'),
        'send_test_auto_newsletter_bat' => fn (Schedule $scheduler) => $scheduler
            ->command('inside:newsletter:scheduled:send --type=newsletter_bat --test')
            ->weekdays()
            ->at('15:00')
            ->timezone('Europe/Paris'),
        'create_newsletter_daily' => fn (Schedule $scheduler) => $scheduler
            ->command('inside:newsletter:scheduled:create newsletter_daily')
            ->weekdays()
            ->at('16:55')
            ->timezone('Europe/Paris'),
        'send_newsletter_daily' => fn (Schedule $scheduler) => $scheduler
            ->command('inside:newsletter:scheduled:send --type=newsletter_daily')
            ->weekdays()
            ->at('17:00')
            ->timezone('Europe/Paris'),
        'users_import_azuread' => fn (Schedule $schedule) => $schedule
            ->command('inside:user:import azuread --disable-not-imported')
            ->daily()
            ->at('02:00')
            ->timezone('Europe/Paris'),
    ],
];
