<?php

use Carbon\Carbon;
use Illuminate\Support\Arr;
use Inside\Host\Bridge\BridgeContent;
use Inside\Support\Str;
use Illuminate\Support\Facades\Storage;

function uploadFile(string $fileName): string
{
    $chunkId = Str::random(32);
    $defaultFilePath = "chunks/$chunkId/$fileName";
    Storage::makeDirectory("chunks/$chunkId");
    Storage::copy(
        "import-resources/$fileName",
        "$defaultFilePath",
    );

    return $defaultFilePath;
}

function getLangcode(mixed $record): string
{
    return in_array(data_get($record, 'language'), list_languages())
        ? data_get($record, 'language')
        : config('app.locale');
}

return [
    'afp_news' => [
        'content_type' => 'news',
        'resources_folder' => 'import-resources', // folder need to be located inside storage/app
        'fields'       => [
            'title' => 'title',
            'image' => fn (mixed $record) => isset($record['picture']['filename'])
                ? uploadFile($record['picture']['filename'])
                : uploadFile('default_image.jpg'),
            'published_at' => fn (mixed $record) => Carbon::createFromTimestamp($record['published_at']),
            'content' => function (mixed $record) {
                $body = [];
                if (isset($record['body']['body']) && !empty($record['body']['body'])) {
                    $htmlBody = $record['body']['body'];
                    $wysiwygImage = $record['body']['wysiwygImages'];
                    $currentYear = date('Y');
                    $currentMonth = date("m");
                    foreach ($wysiwygImage as $imageInfos) {
                        $htmlBody = str_replace(
                            '/sites/asap/' . $imageInfos['src'],
                            env('APP_URL') . "/wysiwyg/images/$currentYear/$currentMonth/" . $imageInfos['fileName'],
                            $htmlBody
                        );
                    }

                    $wysiwygExternalImage = $record['body']['wysiwygExternalImages'];
                    foreach ($wysiwygExternalImage as $externalImage) {
                        $htmlBody = preg_replace(
                            '/(<img[^>]*src=["\'])http:\/\/aurore\.afp\.com[^"]*(' . preg_quote($externalImage['fileName'], '/') . ')([^"]*["\'][^>]*>)/i',
                            '$1' . env('APP_URL') . "/wysiwyg/images/$currentYear/$currentMonth/" . $externalImage['fileName'] . '$3',
                            $htmlBody
                        );
                    }

                    $body[] = [
                        'bundle' => 'text',
                        'body' => $htmlBody,
                    ];
                }

                if (isset($record['file'])) {
                    foreach ($record['file'] as $file) {
                        $body[] = [
                            'bundle' => 'file',
                            'file' => uploadFile($file['filename']),
                        ];
                    }
                }

                if (!empty($record['slider'])) {
                    $slides = [];
                    foreach ($record['slider'] as $slide) {
                        $slides[] = [
                            'bundle' => 'slide',
                            'image' => uploadFile($slide),
                        ];
                    }
                    $body[] = [
                        'bundle' => 'slider',
                        'content' => $slides,
                    ];
                }

                return $body;
            },
            'news_categories' => fn (mixed $record) => reference('news_categories')->from($record['news_category'])->only(getLangcode($record)),
            'langcode' => fn (mixed $record) => getLangcode($record)
        ],
    ],
    'afp_categories' => [
        'content_type' => 'news_categories',
        'format' => [
            'driver' => 'json',
        ],
        'fields'       => [
            'title' => 'title',
            'langcode' => 'langcode'
        ],
    ],
];
