<?php

use Illuminate\Support\Arr;
use Inside\Content\Models\Contents\Users;

return [
    'sync_attributes' => [
        'mail' => 'mail',
        'name' => 'mail',
        'lastname' => 'surname',
        'firstname' => 'givenName',
        'function' => 'jobTitle',
        'mobile_phone' => function (mixed $user) {
            $mobilePhone = $user->onPremisesExtensionAttributes->extensionAttribute14 ?? $user->mobilePhone;
            if (empty($mobilePhone)) {
                return " ";
            }
            return $mobilePhone[0] !== '+' ? '+' . $mobilePhone : $mobilePhone;
        },
        'service_code' => 'department',
        'location' => 'officeLocation',
        'address' => 'streetAddress',
        'zip_code' => 'postalCode',
        'image' => 'photo',
        'phone' => fn (mixed $user) => Arr::first($user->businessPhones) ?? " ",
        'cities' => fn (mixed $user) => reference('cities')->identifiedBy('code')->from($user->city)->get(),
        'contracts_types' => fn (mixed $user) => reference('contracts_types')->identifiedBy('code')->from($user->onPremisesExtensionAttributes->extensionAttribute4)->get(),
        'services' => fn (mixed $user) => reference('services')->identifiedBy('code')->from($user->onPremisesExtensionAttributes->extensionAttribute5)->get(),
        'regions' => fn (mixed $user) => reference('regions')->identifiedBy('code')->from($user->onPremisesExtensionAttributes->extensionAttribute6)->get(),
        'link_teams' => fn (mixed $user) => "https://teams.microsoft.com/l/chat/0/0?users=$user->userPrincipalName",
        'status' => fn () => true,
        'hide_in_directory' => fn (mixed $user) => $user->onPremisesExtensionAttributes->extensionAttribute13 !== 'T',
        'langcode' => fn (mixed $user) => Users::where('email', $user->mail)->first()?->langcode ?? match ($user->preferredLanguage) {
            'fr' => 'fr',
            default => 'en',
        },
    ],
    'custom_attributes' => [
    ],
];
