<?php

namespace Inside\AFP2\Providers;

use Inside\AFP2\Console\CleanCategories;
use Inside\AFP2\Services\Afp2NewsCategoriesCleaner;
use Inside\Support\EventServiceProvider as BaseServiceProvider;

final class ServiceProvider extends BaseServiceProvider
{
    public function register(): void
    {
        if ($this->app->runningInConsole()) {
            $this->app->singleton(
                'clean-news-categories',
                function ($app) {
                    return new CleanCategories(
                        $app->make(Afp2NewsCategoriesCleaner::class)
                    );
                }
            );
            $this->commands('clean-news-categories');
        }
        $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/scheduler.php', 'scheduler');
        $this->mergeConfigTo(__DIR__.'/../../config/newsletters.php', 'newsletters');
        $this->mergeConfigTo(__DIR__.'/../../config/azuread.php', 'azuread');
        $this->mergeConfigTo(__DIR__.'/../../config/imports.php', 'imports');
        $this->mergeConfigTo(__DIR__.'/../../config/archive.php', 'archive');
        $this->mergeConfigTo(__DIR__.'/../../config/news_followers.php', 'news_followers');
    }
}
