<?php

namespace Inside\AFP2\Console;

use Illuminate\Console\Command;
use Inside\AFP2\Services\Afp2NewsCategoriesCleaner;

class CleanCategories extends Command
{
    protected $name = 'clean:news-categories';

    /**
     * @var string
     */
    protected $signature = 'clean:news-categories';

    /**
     * @var string
     */
    protected $description = 'clean afp2 duplicated news categories';


    public function __construct(
        private Afp2NewsCategoriesCleaner $categoriesCleaner
    ) {
        parent::__construct();
    }

    public function handle(): void
    {
        $this->line('[Script Start] : clean afp2 duplicated news categories');
        try {
            $this->categoriesCleaner->execute();
        } catch (\Exception $e) {
            $this->error('Error: ' . $e->getMessage());
        }
        $this->line('[Script End]');
    }
}
