<?php

return [
    '_meta' => [
        'type' => 'newsletter_bat',
        'name' => 'Newsletter Quoi de neuf',
        'fieldsPrefix' => 'nl_',
    ],
    'logo' => [
        'showLogo' => true,
        'logoUrl' => 'vendor/maecia/afp2-back/resources/assets/img/logo.png',
        'logoWidth' => 170,
    ],
    'banner' => [
        'backgroundImageUrl' => 'vendor/maecia/afp2-back/resources/assets/newsletters/daily/header.jpg',
        'backgroundColor' => '#ffff',
        'height',
    ],
    'introduction' => [
        'introductionFieldName' => 'nl_introduction',
    ],
    'sections' => [
        'news' => [
            'types' => ['news'],
            'defaultImageUrl' => 'vendor/maecia/afp2-back/resources/assets/newsletter/news-default.png',
            'showCategoryTitle' => true,
            'showIntroduction' => true,
            'sorts' => ['published_at:desc'],
            'dateFieldName' => 'published_at',
            'link' => [
                'sectionLinkUrl' => 'news',
                'sectionTextColor' => '#3B59F6',
            ],
        ],
        'events' => [
            'types' => ['events'],
            'defaultCategoryColor' => '#3B59F6',
            'link' => [
                'sectionLinkUrl' => 'events',
                'sectionTextColor' => '#3B59F6',
            ],
        ],
        'jobs_offers' => [
            'sectionType' => 'job_offers',
            'types' => ['jobs_offers'],
            'parentFieldName' => 'contracts_types',
            'leftLineColor' => '#FAD223',
            'link' => [
                'sectionLinkUrl' => 'jobs',
                'sectionTextColor' => '#3B59F6',
            ],
            'modal' => [
                'name' => 'job-offers'
            ]
        ],
        'documents' => [
            'types' => ['documents'],
            'parentFieldName' => 'folders',
            'leftLineColor' => '#AF1F50',
            'link' => [
                'sectionLinkUrl' => 'ged',
                'sectionTextColor' => '#3B59F6',
            ],
        ],
        'news_cse' => [
            'types' => ['news_cse' => 'news'],
            'sectionType' => 'news',
            'defaultImageUrl' => 'vendor/maecia/afp2-back/resources/assets/newsletter/news-default.png',
            'showCategoryTitle' => true,
            'showIntroduction' => true,
            'sorts' => ['published_at:desc'],
            'dateFieldName' => 'published_at',
            'link' => [
                'sectionLinkUrl' => 'news',
                'sectionTextColor' => '#3B59F6',
                'sectionLinkKey' => ''
            ],
        ],
    ],
];
