<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;
use Illuminate\Support\Facades\Artisan;

class UpdateMobilePhoneFieldType extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $fields = [
            'mobile_phone' => [
                "title" =>  [
                    'fr' => 'Mobile',
                    'en' => 'Mobile phone',
                ],
                'weight' => 7
            ],
            'phone' => [
                "title" =>  [
                    'fr' => 'Téléphone',
                    'en' => 'Phone',
                ],
                'weight' => 6
            ]
        ];
        collect($fields)->each(
            fn ($properties, $fieldName) =>
        $this->getBridge()
            ?->contentTypeCreateOrUpdateField(
                type: 'users',
                fieldName: $fieldName,
                options: [
                    'name' => $fieldName,
                    'searchable' => false,
                    'translatable' => false,
                    'search_result_field' => false,
                    'searchable_filter' => false,
                    'required' => false,
                    'weight' => $properties['weight'],
                    'title' => $properties['title'],
                    'widget' => [
                        'type' => BridgeContentType::STRING_WIDGET,
                        'settings' => [
                            'size' => 60,
                            'placeholder' => '',
                        ],
                        'weight' => $properties['weight'],
                    ],
                    'type' => BridgeContentType::TEXT_FIELD,
                    'settings' => [
                        'max_length' => 255,
                        'is_ascii' => false,
                        'case_sensitive' => false,
                        'cardinality' => 1,
                    ]
                ],
                weight: $properties['weight']
            )
        );
        $this->finishUp();
        $this->call('models:rebuild');
    }
}
