<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;
use Illuminate\Support\Facades\Artisan;

class UpdateMarkerType extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->getBridge()?->updateContentTypeOptions('marker', [
            'translatable' => true,
        ]);
        $this->getBridge()?->contentTypeCreateOrUpdateField('marker', 'regions', [
            'name' => 'regions',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => true,
            'required' => true,
            'weight' => 5,
            'title' => [
                'fr' => 'Régions',
                'en' => 'Regions',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 5,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['regions'],
                'cardinality' => -1,
            ],
            'selectable_all' => true,
        ]);
        $this->finishUp();

        $this->getBridge()?->changeFieldFormOptions('marker', 'langcode', true, 'group_advanced_options');
    }
}
