<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContent;
use Inside\Content\Models\Contents\NewsCategories;

class ExcludeCseFromListing extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContent();
        NewsCategories::each(fn (NewsCategories $content) => $bridge->contentUpdate(
            'news_categories',
            [
                'uuid' => $content->uuid,
                'exclude_from_listing' => $content->title === "CSE",
                'exclude_from_homepage' => $content->title === "CSE"
            ]
        ));
    }

    public function down(): void
    {
    }
}
