<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

class CreateUsersHideInDirectoryField extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->getBridge()?->contentTypeCreateOrUpdateField(
            type: 'users',
            fieldName: 'hide_in_directory',
            options: [
                'name' => 'is_maintenance',
                'searchable' => true,
                'translatable' => false,
                'search_result_field' => false,
                'searchable_filter' => true,
                'required' => false,
                'weight' => 16,
                'title' => [
                    'fr' => "Ne pas afficher dans l'annuaire",
                    'en' => 'Hide in directory',
                ],
                'description' => [
                    'fr' => 'Si cette case est cochée l\'utilisateur ne remontera pas dans l\'annuaire de l\'intranet',
                    'en' => 'If this box is checked the user will not go up in the intranet directory',
                ],
                'widget' => [
                    'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                    'settings' => [
                        'display_label' => true,
                    ],
                    'weight' => 16,
                ],
                'type' => BridgeContentType::BOOLEAN_FIELD,
                'settings' => [
                    'cardinality' => 1,
                ],
                'default' => false,
            ],
        );
        $this->finishUp();
    }
}
