<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Blocks;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

final class CreateBlocksDisplayInSidebarField extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->getBridge()?->contentTypeCreateOrUpdateField(
            type: 'blocks',
            fieldName: 'display_in_sidebar',
            options: [
                'name' => 'display_in_sidebar',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'title' => [
                    'fr' => 'Afficher dans la Sidebar',
                    'en' => 'Display in the Sidebar',
                ],
                'widget' => [
                    'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                    'settings' => [
                        'display_label' => true,
                    ],
                ],
                'type' => BridgeContentType::BOOLEAN_FIELD,
                'settings' => [
                    'cardinality' => 1,
                ],
                'default' => false,
            ],
            weight: 0
        );

        $bridgeContent = new BridgeContent();
        Blocks::query()
            ->whereNull('display_in_sidebar')
            ->each(fn (Blocks $block) => $bridgeContent->contentUpdate($block->content_type, ['uuid' => $block->uuid, 'display_in_sidebar' => false]));

        $this->finishUp();
    }
}
