<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Content;
use Inside\Host\Bridge\BridgeContent;

final class PurgeServicesRegions extends Migration
{
    public function up(): void
    {
        $bridgeContent = new BridgeContent();

        collect(['services', 'regions'])
            ->each(fn (string $type) => type_to_class($type)::each(function (Content $content) use ($bridgeContent) {
                if ($content->uuid) {
                    $bridgeContent->contentDelete($content->content_type, $content->uuid);
                }
            }));
    }
}
