<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema;
use Inside\Content\Models\Field;
use Inside\Host\Migrations\CreateContentTypes;

final class ChangeAdsToPostingsContentType extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        if (Schema::hasModel('ads')) {
            $this->getBridge()?->contentTypeDelete('ads');
        }

        if (Schema::hasModel('ads_categories')) {
            $this->getBridge()?->contentTypeDelete('ads_categories');
        }

        $this->migrateContent('postings_categories');
        $this->migrateContent('postings');

        $this->finishUp();
    }
}
