<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Field;

final class FixAuthorFieldsLabels extends Migration
{
    public function up(): void
    {
        Field::where('name', 'author')
            ->each(function (Field $field) {
                $options = $field->options;

                if (! isset($options['title'])) {
                    return;
                }

                $options['title'] = [
                    'fr' => 'Auteur',
                    'en' => 'Author',
                ];

                $field->update(['options' => $options]);
            });
    }
}
