<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

final class UpdateAdsContentTypes extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        if (Schema::hasModel('adds')) {
            $this->getBridge()?->contentTypeDelete('adds');
        }

        if (Schema::hasModel('adds_categories')) {
            $this->getBridge()?->contentTypeDelete('adds_categories');
        }

        if (Schema::hasModel('ads') && Schema::hasField('ads', 'location')) {
            $this->getBridge()?->contentTypeDeleteField('node', 'ads', 'location');
        }

        $this->migrateContent('ads_categories');
        $this->migrateContent('ads');

        $this->finishUp();
    }
}
