<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

final class UpdateContentTypes extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $image = [
            'name' => 'image',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Image de prévisualisation',
                'en' => 'Preview Image',
            ],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight' => 1,
            ],
            'type' => BridgeContentType::IMAGE_FIELD,
            'settings' => [
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ];

        $this->getBridge()?->contentTypeCreateOrUpdateField('spaces', 'image', $image, 2);
        $this->getBridge()?->contentTypeCreateOrUpdateField('ads', 'image', $image, 1);

        $this->migrateContent('modals');
        $this->migrateContent('news_categories');

        $this->finishUp();
    }
}
