<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Content\Models\Contents\Custom;
use Inside\Host\Bridge\BridgeContent;

final class SeedCustoms extends Migration
{
    public function up(): void
    {
        Artisan::call('models:rebuild');

        $customs = collect([
            [
                'custom_slug' => 'news',
                'redirection_page' => 'NewsListingPage',
                'title' => [
                    'fr' => 'Actualités',
                    'en' => 'News',
                ],
            ],
            [
                'custom_slug' => 'calendar',
                'redirection_page' => 'EventsCalendarPage',
                'title' => [
                    'fr' => 'Événements',
                    'en' => 'Events',
                ],
            ],
            [
                'custom_slug' => 'directory',
                'redirection_page' => 'DirectoryPage',
                'title' => [
                    'fr' => 'Ensemble, partout dans le monde',
                    'en' => 'Together, Worldwide',
                ],
            ],
            [
                'custom_slug' => 'organizational-charts',
                'redirection_page' => 'OrganizationsListingPage',
                'title' => [
                    'fr' => 'Organigrammes',
                    'en' => 'Organizational Charts',
                ],
            ],
            [
                'custom_slug' => 'map',
                'redirection_page' => 'MapPage',
                'title' => [
                    'fr' => "Les bureaux de L'AFP",
                    'en' => 'AFP Offices',
                ],
                'introduction' => [
                    'fr' => 'Cliquez sur chaque point pour en découvrir plus.',
                    'en' => 'Click on each point to learn more.',
                ],
            ],
            [
                'custom_slug' => 'jobs',
                'redirection_page' => 'JobsListingPage',
                'title' => [
                    'fr' => 'Postes à pourvoir',
                    'en' => 'Job Openings',
                ],
                'introduction' => [
                    'fr' => "Retrouvez toutes les offres d'emploi du groupe. Que ce soit pour de la mobilité interne ou pour de la cooptation, n'hésitez pas à les consulter régulièrement !",
                    'en' => 'Find all job offers from the group. Whether it is for internal mobility or cooptation, feel free to check them regularly!',
                ],
            ],
            [
                'custom_slug' => 'adds',
                'redirection_page' => 'AddsListingPage',
                'title' => [
                    'fr' => 'Petites annonces',
                    'en' => 'Classifieds',
                ],
            ],
            [
                'custom_slug' => 'spaces',
                'redirection_page' => 'SpacesListingPage',
                'title' => [
                    'fr' => 'Espace métiers',
                    'en' => 'Business Space',
                ],
            ],
            [
                'custom_slug' => 'ged',
                'redirection_page' => 'GedPage',
                'title' => [
                    'fr' => 'Bibliothèque de ressources',
                    'en' => 'Resource Library',
                ],
                'introduction' => [
                    'fr' => 'Retrouvez tous les documents, photos, fiches pratiques...',
                    'en' => 'Find all documents, photos, practical sheets...',
                ],
            ],
            [
                'custom_slug' => 'tools',
                'redirection_page' => 'ToolsPage',
                'title' => [
                    'fr' => 'Outils et services',
                    'en' => 'Tools and Services',
                ],
            ],
        ]);


        $locale = config('app.locale');
        $languages = collect(list_languages())->diff([$locale])->values();

        $bridge = new BridgeContent();

        $customs->each(function (array $custom) use ($bridge, $locale, $languages) {
            $original = $this->createOrUpdate($bridge, $custom, $locale);
            $original = Custom::findOrFail($original);
            $custom['uuid_host'] = $original->uuid_host;
            $languages->each(fn ($language) => $this->createOrUpdate($bridge, $custom, $language));
        });
    }

    private function createOrUpdate(BridgeContent $bridge, array $custom, string $language): ?string
    {
        $data = array_map(fn ($value) => $value[$language] ?? $value, $custom);
        $data['langcode'] = $language;

        $existing = Custom::query()
            ->where('redirection_page', $data['redirection_page'])
            ->where('langcode', $data['langcode'])
            ->first();

        if ($existing instanceof Custom) {
            $data['uuid'] = $existing->uuid;
            return $bridge->contentUpdate('custom', $data, true);
        }

        return $bridge->contentInsert('custom', $data, true, true);
    }
}
