<?php

use Inside\Database\Eloquent\Builder;

return [
    'types' => [
        'newsletter_bat' => [
            'title' => 'newsletter.newsletter_bat.title',
            'notification' => [
                'view' => 'newsletter_bat',
                'title' => 'notifications.create.newsletters.bat.sent.mail.title',
                'description' => 'notifications.create.newsletters.bat.sent.mail.description',
                'mail' => [
                    'subject' => 'newsletters.scheduled.newsletter_bat.title',
                ],
                'titleDateFormat' => 'd/m/Y',
            ],
            'default_roles' => ['authenticated'],
            'scheduled' => env('ENABLE_SCHEDULED_NEWSLETTER_DAILY', true),
            'scheduled_options' => [
                'date_limit' => 2,
                'roles' => ['authenticated'],
                'test_roles' => ['super_administrator'],
                'introductionFieldName' => 'nl_introduction',
                'fields' => [
                    'nl_news' => [
                        'content_type' => 'news',
                        'custom_query' => function (Builder $query) {
                            $categories = str(env('AFP2_CSE_NEWS_CATEGORIES_UUID_HOST', ''))->explode(',');

                            if ($categories->isNotEmpty()) {
                                $query->whereHas('newsCategories', fn (Builder $query) => $query->whereNotIn('uuid_host', $categories));
                            }

                            $query->orderBy('published_at', 'desc');
                            return $query;
                        },
                    ],
                    'nl_events' => 'events',
                    'nl_jobs_offers' => 'jobs_offers',
                    'nl_documents' => 'documents',
                    'nl_news_cse' => [
                        'content_type' => 'news',
                        'custom_query' => function (Builder $query) {
                            $categories = str(env('AFP2_CSE_NEWS_CATEGORIES_UUID_HOST', ''))->explode(',');

                            if ($categories->isNotEmpty()) {
                                return $query->whereHas('newsCategories', fn (Builder $query) => $query->whereIn('uuid_host', $categories));
                            }

                            $query->orderBy('published_at', 'desc');
                            return null;
                        },
                    ],
                ],
            ],
        ],
        'newsletter_daily' => [
            'title' => 'newsletter.newsletter_daily.title',
            'notification' => [
                'view' => 'newsletter_daily',
                'title' => 'notifications.create.newsletters.daily.sent.mail.title',
                'description' => 'notifications.create.newsletters.daily.sent.mail.description',
                'mail' => [
                    'subject' => 'newsletters.scheduled.newsletter_daily.title',
                ],
                'titleDateFormat' => 'd/m/Y',
            ],
            'default_roles' => ['authenticated'],
            'scheduled' => env('ENABLE_SCHEDULED_NEWSLETTER_DAILY', true),
            'scheduled_options' => [
                'date_limit' => 2,
                'roles' => ['authenticated'],
                'test_roles' => ['super_administrator'],
                'introductionFieldName' => 'nl_introduction',
                'fields' => [
                    'nl_news' => [
                        'content_type' => 'news',
                        'custom_query' => function (Builder $query) {
                            $categories = str(env('AFP2_CSE_NEWS_CATEGORIES_UUID_HOST', ''))->explode(',');

                            if ($categories->isNotEmpty()) {
                                $query->whereHas('newsCategories', fn (Builder $query) => $query->whereNotIn('uuid_host', $categories));
                            }

                            $query->orderBy('published_at', 'desc');
                            return $query;
                        },
                    ],
                    'nl_events' => 'events',
                    'nl_jobs_offers' => 'jobs_offers',
                    'nl_documents' => 'documents',
                    'nl_news_cse' => [
                        'content_type' => 'news',
                        'custom_query' => function (Builder $query) {
                            $categories = str(env('AFP2_CSE_NEWS_CATEGORIES_UUID_HOST', ''))->explode(',');

                            if ($categories->isNotEmpty()) {
                                return $query->whereHas('newsCategories', fn (Builder $query) => $query->whereIn('uuid_host', $categories));
                            }

                            $query->orderBy('published_at', 'desc');
                            return null;
                        },
                    ],
                ],
            ],
        ],
        'newsletter_weekly' => [
            'title' => 'newsletter.newsletter_weekly.title',
            'notification' => [
                'view' => 'newsletter_weekly',
                'title' => 'notifications.create.newsletters.weekly.sent.mail.title',
                'description' => 'notifications.create.newsletters.weekly.sent.mail.description',
                'mail' => [
                    'subject' => 'newsletters.scheduled.newsletter_weekly.title',
                ],
                'titleDateFormat' => 'd/m/Y',
            ],
            'default_roles' => ['authenticated'],
            'scheduled' => env('ENABLE_SCHEDULED_NEWSLETTER_WEEKLY', true),
            'scheduled_options' => [
                'roles' => ['authenticated'],
                'introductionFieldName' => 'nl_introduction',
                'fields' => [
                    'nl_jobs_offers' => 'jobs_offers',
                ],
            ],
        ],
    ],
];
