export default {
  globals: {
    notificationRedirectionsContentTypes: ['news'],
    notificationRedirections: {
      news: async ({ data }) => ({
        name: 'NewsPage',
        params: {
          slug: data.slug[0]
        }
      })
    }
  },
  'inside-agenda': {
    allowedViews: ['week', 'month'],
    rootRoute: {
      fr: 'salles-de-reunion'
    }
  },
  'inside-news': {
    bookmarkEnabled: false
  },
  'inside-ged': {
    rootRoute: {
      fr: 'bibliotheque-de-ressources'
    }
  },
  'inside-users': {
    login: {
      useGradient: false,
      useImage: true
    },
    shortcuts: {
      max: 4
    },
    profil: {
      enabledProfilTabs: [
        { name: 'profil', restrictions: [], icon: 'user' },
        { name: 'password', restrictions: [] },
        { name: 'shortcuts', restrictions: [], icon: 'news' }
      ]
    }
  }
}
