import { http } from '@inside-library/helpers/Http'

export default {
  spaces: {
    add: ({ data }) => ({
      name: 'SpacesPage',
      params: { slug: data.slug[0] }
    })
  },
  spacesCategories: {
    fields: [{ spaces: ['slug'] }],
    add: ({ data }) => ({
      name: 'SpacesPage',
      params: { slug: data.spaces.data[0].slug[0] }
    }),
    delete: ({ data }) => ({
      name: 'SpacesPage',
      params: { slug: data.spaces.data[0].slug[0] }
    })
  },
  spacesDocuments: {
    fields: ['file', { spaces: ['slug'] }],
    add: ({ data }) => ({
      name: 'SpacesPage',
      params: { slug: data.spaces.data[0].slug[0] }
    }),
    delete: ({ data }) => ({
      name: 'SpacesPage',
      params: { slug: data.spaces.data[0].slug[0] }
    }),
    globalSearch: async ({ data }) => {
      const { data: spacesCategories } = await http.get(
        'content/spaces_documents',
        {
          fields: ['uuid', { spaces_categories: ['uuid', 'title'] }],
          filters: { 'uuid:eq': data.uuid }
        }
      )

      const { data: spaces } = await http.get('content/spaces_categories', {
        fields: ['uuid', { spaces: ['uuid', 'title', 'slug'] }],
        filters: {
          'uuid:eq': spacesCategories[0].spaces_categories.data[0].uuid
        }
      })

      return {
        route: {
          name: 'SpacesPage',
          params: {
            slug: spaces[0].spaces.data[0].slug[0]
          }
        }
      }
    }
  }
}
