<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

class ServicesAsReference extends Migration
{
    use CreateContentTypes;

    /** @var BridgeContentType $bridge */
    protected $bridge;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $this->migrateContent('services');

        $this->bridge->contentTypeDeleteField('user', 'user', 'service');
        $this->bridge->contentTypeCreateOrUpdateField(
            'users',
            'services',
            [
                'name' => 'services',
                'type' => BridgeContentType::REFERENCE_FIELD,
                'searchable' => true,
                'translatable' => false,
                'search_result_field' => false,
                'required' => false,
                'title' => [
                    'fr' => 'Service',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                ],
                'settings' => [
                    'target_type' => ['services'],
                    'cardinality' => 1,
                ],
            ]
        );

        $this->finishUp();
    }

    public function down(): void
    {
    }
}
