<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

class UsersMigration extends Migration
{
    use CreateContentTypes;

    /** @var BridgeContentType $bridge */
    protected $bridge;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $fields = [
            'shortcuts_menus'
        ];

        foreach ($fields as $field) {
            $this->bridge->contentTypeDeleteField('user', 'user', $field);
        }

        $this->migrateContent('users');

        $this->finishUp();
    }

    public function down(): void
    {
    }
}
