<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

class ContentsTypesMigration extends Migration
{
    use CreateContentTypes;

    private const CONTENT_TYPES = [
        'custom',
        'folders',
        'documents',
        'events_categories',
        'events',
        'news_categories',
        'news',
        'pages',
        'spaces',
        'spaces_categories',
        'spaces_documents',
        'tools_categories',
        'tools',
    ];

    public function up(): void
    {
        $this->bootUp(__FILE__);

        foreach (self::CONTENT_TYPES as $contentType) {
            $this->migrateContent($contentType);
        }

        $this->finishUp();
    }

    public function down(): void
    {
        $this->bridge = new BridgeContentType();

        foreach (self::CONTENT_TYPES as $contentType) {
            $this->bridge->contentTypeDelete($contentType);
        }
    }
}
