<?php

namespace Inside\AFAL\Providers;

use Inside\AFAL\Http\Middleware\WeatherDataMiddleware;
use Inside\Providers\ServiceProvider as BaseServiceProvider;
use Psr\Container\ContainerExceptionInterface;
use Psr\Container\NotFoundExceptionInterface;

/**
 * AFAL Service provider.
 *
 * @category Class
 * @package  Inside\AFAL\Providers\ServiceProvider
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class ServiceProvider extends BaseServiceProvider
{
    public function register(): void
    {
        try {
            $this->mergeConfigTo(__DIR__.'/../../config/openweathermap.php', 'openweathermap');
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/csv.php', 'csv');
        } catch (NotFoundExceptionInterface|ContainerExceptionInterface) {
        }

        if (method_exists($this->app, 'middleware')) {
            $this->app->middleware([
                WeatherDataMiddleware::class,
            ]);
        }
    }
}
