<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Lang;
use Inside\Host\Bridge\BridgeContentType;

class AddExceptionsFieldToReservations extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            'rooms_reservations',
            'exceptions',
            [
                'name'                => 'exceptions',
                'searchable'          => false,
                'translatable'        => false,
                'default'             => '',
                'search_result_field' => false,
                'required'            => false,
                'weight'              => 1,
                'title'               => [
                    'fr' =>  Lang::get('reservation.fields.exceptions', [], 'fr'),
                    'en' =>  Lang::get('reservation.fields.exceptions', [], 'en'),
                ],
                'description'         => [],
                'widget'              => [
                    'type'   => BridgeContentType::LONGTEXT_WIDGET,
                    'weight' => 1,
                ],
                'type'                => BridgeContentType::TEXTAREA_FIELD,
                'settings'            => [],
            ]
        );
    }
}
