<?php

return [
    'files' => [
        'afal' => [
            'path' => __DIR__.'/../../../../imports/afal-annuaire.csv',
            'separator' => ';',
            'fields' => [
                'name' => 'email',
                'mail' => 'email',
                'firstname' => 'prénom',
                'lastname' => 'nom',
                'function' => 'fonction',
                'phone' => 'ligne directe',
                'mobile' => 'ligne portable',
                'services' => function ($record, \Inside\Host\Bridge\BridgeContent $bridge) {
                    $name = trim(ucwords(strtolower($record['service'])));

                    $service = \Inside\Content\Models\Contents\Services::where('title', $name)->first();

                    if ($service) {
                        $uuid = $service->uuid;
                    } else {
                        $uuid = $bridge->contentInsert(
                            'services',
                            [
                                'title' => $name,
                                'type' => 'node',
                                'bundle' => 'services',
                            ]
                        );
                    }

                    if ($uuid) {
                        return [$uuid];
                    }

                    return null;
                },
                'status' => function ($record, \Inside\Host\Bridge\BridgeContent $bridge) {
                    return 1;
                },
                'image' => function ($record, \Inside\Host\Bridge\BridgeContent $bridge) {
                    $insideUser = \Inside\Content\Models\Contents\Users::query()->where('name', trim($record['email']))->first();

                    /**
                     * If the user already has a picture set, return false.
                     * The image attribute will then be removed in the post_sync callback
                     */
                    if ($insideUser && !empty($insideUser->getAttribute('image'))) {
                        return false;
                    }

                    $photo = $record['photo utilisateur'];

                    if (!$photo) {
                        return null;
                    }
                    $fileName = "$photo.jpg";
                    $imgPath = "profile/$fileName";

                    if (!\Illuminate\Support\Facades\Storage::exists($imgPath)) {
                        return null;
                    }

                    $chunkId = \Illuminate\Support\Str::random(32);
                    $finalFolderPath = "chunks/$chunkId";
                    $finalPath = "$finalFolderPath/$fileName";

                    \Illuminate\Support\Facades\Storage::makeDirectory($finalFolderPath);
                    \Illuminate\Support\Facades\Storage::copy($imgPath, $finalPath);

                    return $finalPath;
                }
            ],
        ],
    ],
    'cleandata' => function (&$data) {
        if ($data['image'] === false) {
            unset($data['image']);
        }
    }
];
