import SpacePage from '../pages/SpacePage'
import { fetchSpacePage } from '../components/space/space'

import AdminAdvancedSettingsHomePage from '../pages/advanced-settings/AdminAdvancedSettingsHomePage'
import { fetchSettings } from '@inside-administration/fetch'

import { withFetch } from 'inside-collection/hocs'

export default [
  {
    name: 'HomePage',
    component: () => import('../pages/HomePage'),
    meta: { disabled: false }
  },
  {
    name: 'GedPage',
    props: { linkTypes: null, cardOverlayEnabled: false },
    meta: { disabled: false }
  },
  {
    name: 'NewsListingPage',
    meta: { disabled: false }
  },
  {
    name: 'NewsPage',
    meta: { disabled: false }
  },
  {
    name: 'MapPage',
    meta: { disabled: false }
  },
  {
    name: 'ToolsPage',
    meta: { disabled: false },
    props: {
      extraFilters: {
        sort: ['weight:asc', 'title:asc'],
        'published_at:lte': 'now()'
      },
      toolsFilters: {
        reverse: true,
        'status:eq': 1,
        sort: 'weight:asc',
        'published_at:lte': 'now()'
      }
    }
  },
  {
    name: 'DirectoryPage',
    component: () => import('../pages/DirectoryPage'),
    path: 'annuaire-des-collaborateurs',
    meta: { disabled: false }
  },
  {
    name: 'EventsCalendarPage',
    meta: { disabled: false },
    props: {
      bannerData: {
        introductionKey: 'introduction',
        imageKey: 'image',
        add: ['events', 'events_categories']
      }
    }
  },
  {
    name: 'EventPage',
    meta: { disabled: false }
  },
  {
    name: 'SpacePage',
    path: '/espaces/:slug',
    meta: { content: 'spaces' },
    component: withFetch(SpacePage, { size: 'xxl', watch: true })(
      fetchSpacePage
    )
  },
  {
    name: 'SpacesGedPage',
    path: '/espaces/:slug/documents',
    component: () => import('../pages/SpacesGedPage')
  },
  {
    name: 'SimplePage',
    meta: { disabled: false }
  },
  {
    name: 'AdminAdvancedSettingsHomePage',
    component: withFetch(AdminAdvancedSettingsHomePage, { size: 'xxl' })(
      fetchSettings
    ),
    meta: { admin: true, display: true }
  }
]
