import { http } from '@inside-library/helpers/Http'

export default {
  eventsCategories: {
    add: () => '/agenda-de-l-etude-et-evenements',
    delete: () => '/agenda-de-l-etude-et-evenements'
  },
  markers: {
    add: () => ({
      name: 'MapPage'
    }),
    delete: () => ({
      name: 'MapPage'
    })
  },
  documentsRh: {
    add: async ({ data }) => {
      try {
        const { data: docData } = await http.get('content/documents_rh', {
          filters: {
            'uuid:eq': data.uuid
          },
          fields: [{ folders_rh: ['uuid'] }]
        })

        const { data: spaceSlug } = await http.get('content/spaces', {
          fields: ['slug'],
          filters: { 'status:eq': 1, limit: 1 }
        })

        return {
          name: 'SpacesGedPage',
          params: {
            slug: spaceSlug[0]?.slug
          },
          query: {
            folder: docData[0]?.folders_rh?.data[0]?.uuid
          }
        }
      } catch (err) {
        throw new Error(err)
      }
    },
    delete: async () => {
      try {
        const { data: spaceSlug } = await http.get('content/spaces', {
          fields: ['slug'],
          filters: { 'status:eq': 1, limit: 1 }
        })

        return {
          name: 'SpacesGedPage',
          params: {
            slug: spaceSlug[0]?.slug
          }
        }
      } catch (err) {
        throw new Error(err)
      }
    },
    globalSearch: ({ vm, data }) => ({
      action: () =>
        vm.triggerModal(
          'doc',
          'fetch',
          { item: data, content: data.content_type },
          { layout: 'right', transition: 'fadeInLeft' }
        )
    })
  },
  foldersRh: {
    add: async ({ data }) => {
      try {
        const { data: spaceSlug } = await http.get('content/spaces', {
          fields: ['slug'],
          filters: { 'status:eq': 1, limit: 1 }
        })

        return {
          name: 'SpacesGedPage',
          params: {
            slug: spaceSlug[0]?.slug
          },
          query: {
            folder: data.uuid
          }
        }
      } catch (err) {
        throw new Error(err)
      }
    },
    delete: async () => {
      try {
        const { data: spaceSlug } = await http.get('content/spaces', {
          fields: ['slug'],
          filters: { 'status:eq': 1, limit: 1 }
        })

        return {
          name: 'SpacesGedPage',
          params: {
            slug: spaceSlug[0]?.slug
          }
        }
      } catch (err) {
        throw new Error(err)
      }
    },
    globalSearch: () => ({
      routeAs: 'add'
    })
  },
  spaces: {
    add: ({ data }) => ({
      name: 'SpacePage',
      params: { slug: data.slug[0] }
    })
  }
}
