export default {
  'inside-commons': {
    banner: {
      imageKey: 'image'
    }
  },
  'inside-news': {
    showBookmarks: false,
    fullLikesOnMobileDevices: true,
    rootRoute: {
      fr: '14-pyramides-infos'
    }
  },
  'inside-ged': {
    e2e: {
      path: 'documents-etude',
      useLinks: false
    },
    useV2: true,
    rootRoute: {
      fr: 'documents-etude'
    }
  },
  'inside-teams': {
    rootRoute: {
      fr: 'communautes'
    }
  },
  'inside-users': {
    login: {
      useGradient: false,
      useImage: true
    },
    shortcuts: {
      max: 4
    },
    e2e: {
      userNav: ['profile', 'shortcuts', 'logout']
    },
    profil: {
      enabledProfilTabs: [
        { name: 'profil', restrictions: [], icon: 'user' },
        { name: 'password', restrictions: [] },
        { name: 'shortcuts', restrictions: [], icon: 'news' }
      ]
    }
  },
  'inside-events': {
    rootRoute: {
      fr: 'agenda-de-l-etude-et-evenements'
    },
    fullLikesOnMobileDevices: true,
    subscriptionEnabled: true
  },
  'inside-maps': {
    mainContentType: 'markers',
    rootRoute: {
      fr: 'carte'
    }
  },
  'inside-newcomers': {
    extraFields: [
      {
        field: { functions: ['title'] },
        data: data => data?.functions?.title,
        class: 'function'
      },
      {
        field: { services: ['title'] },
        data: data => data?.services?.title,
        class: 'service'
      }
    ]
  },
  'inside-tools': {
    rootRoute: {
      fr: 'liens-et-sites'
    }
  }
}
