import { http } from '@inside-library/helpers/Http'

export const fetchSpacePage = async ({ $route }) => {
  try {
    const { data } = await http.get('content/spaces', {
      fields: [
        'uuid',
        'admin',
        'title',
        'slug',
        'content_type',
        'description',
        'image',
        'admin',
        {
          referents: {
            fields: [
              'uuid',
              'firstname',
              'lastname',
              'image',
              'functions',
              'phone'
            ],
            filters: {
              'status:eq': 1
            }
          }
        }
      ],
      filters: { 'slug:eq': $route.params.slug, 'status:eq': 1, limit: 1 }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}
