export default {
  documents: {
    extendedUrl: ['uuid'],
    modalFields: [
      'uuid',
      'title',
      'content_type',
      'admin',
      'content',
      'published_at',
      'updated_at',
      'file',
      { folders: ['title'] },
      { authors: ['uuid', 'firstname', 'lastname'] }
    ]
  },
  documents_rh: {
    onDelete: 'espace-rh',
    modalFields: [
      'uuid',
      'title',
      'content_type',
      'admin',
      'content',
      'published_at',
      'updated_at',
      'file',
      { folders: ['title'] },
      { authors: ['uuid', 'firstname', 'lastname'] }
    ]
  },
  groups_documents: {
    modalFields: [
      'uuid',
      'title',
      'content_type',
      'admin',
      'content',
      'published_at',
      'updated_at',
      'file',
      { groups_folders: ['title'] },
      { authors: ['uuid', 'firstname', 'lastname'] }
    ]
  },
  users: {
    extendedUrl: ['uuid'],
    modalFields: [
      'uuid',
      'firstname',
      'lastname',
      'email',
      'image',
      'linkedin',
      'phone',
      'line',
      'mobile',
      'services',
      'floor',
      'hide_email',
      { services: ['title'] },
      { functions: ['title'] },
      {
        colleague: [
          'uuid',
          'firstname',
          'lastname',
          'phone',
          'image',
          'content_type',
          { functions: ['title'] }
        ]
      }
    ]
  }
}
