<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class CreateToolsCategories extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $bridge = new BridgeContentType();

        $this->bootUp(__FILE__);
        $this->migrateContent('tools_categories');
        $this->finishUp();

        $bridge->contentTypeCreateOrUpdateField('tools', 'tools_categories', [
            'name' => 'tools_categories',
            'searchable' => false,
            'translatable' => false,
            'default' => null,
            'search_result_field' => false,
            'required' => true,
            'weight' => 3,
            'title' => [
                'fr' => 'Catégorie d\'outils'
            ],
            'description' => [
                'fr' => 'Choix de la catégorie dans laquelle cet outil doit remonter',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 4,
                'group' => 'group_options',
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => 'tools_categories',
                'cardinality' => -1,
            ],
        ]);
    }

    public function down(): void
    {
    }
}
