<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddHideEmailFieldToUsers extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            'users',
            'hide_email',
            [
                'name' => 'hide_email',
                'searchable' => false,
                'translatable' => false,
                'default' => false,
                'search_result_field' => false,
                'required' => false,
                'weight' => 10,
                'title' => [
                    'fr' => 'Ne pas remonter l\'email utilisateur dans l\'annuaire',
                ],
                'description' => [
                    'fr' => '',
                ],
                'widget' => [
                    'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                    'settings' => [
                        'display_label' => true,
                    ],
                    'group' => 'group_advanced_options',
                ],
                'type' => BridgeContentType::BOOLEAN_FIELD,
                'settings' => [
                    'cardinality' => 1,
                ],
            ],
            10
        );
    }

    public function down(): void
    {
    }
}
