<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class EditGedFileField extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();
        $bridge->contentTypeCreateOrUpdateField('documents', 'file', [
            'name' => 'file',
            'searchable' => true,
            'translatable' => false,
            'default' => null,
            'search_result_field' => true,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Fichier',
            ],
            'description' => [],
            'widget' => [
                'type' => BridgeContentType::FILE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                ],
            ],
            'type' => BridgeContentType::FILE_FIELD,
            'settings' => [
                'display_field' => false,
                'display_default' => false,
                'uri_scheme' => 'public',
                'target_type' => 'file',
                'cardinality' => 1,
            ],
        ], 1);
    }

    public function down(): void
    {
    }
}
