<?php

use Illuminate\Support\Facades\File;
use Illuminate\Support\Str;
use Inside\Host\Bridge\BridgeContent;

if (!function_exists('14py_get_string')) {
    function get_string_14py(array $record, string $column): ?string
    {
        if (!empty(trim($record[$column]))) {
            return trim($record[$column]);
        }

        return null;
    }
}
if (!function_exists('get_entity_14py')) {
    function get_entity_14py(array $record, BridgeContent $bridge, string $bundle, string $column): ?array
    {
        $name = trim(ucwords(strtolower($record[$column])));


        if (empty($name)) {
            return null;
        }

        $query = call_user_func('Inside\\Content\\Models\\Contents\\'.Str::studly($bundle).'::query');

        $entity = $query->where('title', $name)->first();

        if ($entity) {
            return [$entity->uuid];
        }

        $uuidBridge = $bridge->contentInsert($bundle, [
            'title' => $name,
            'type' => 'node',
            'bundle' => $bundle,
            'uid' => 1,
        ]);

        if ($uuidBridge) {
            return [$uuidBridge];
        }

        return null;
    }
}
return [
    'files' => [
        '14py' => [
            'path' => __DIR__.'/../../../../imports/import.csv',
            'separator' => ',',
            'fields' => [
                'name' => function ($record, BridgeContent $bridge) {
                    return trim($record['mail']);
                },
                'mail' => function ($record, BridgeContent $bridge) {
                    return trim($record['mail']);
                },
                'firstname' => function ($record, BridgeContent $bridge) {
                    return get_string_14py($record, 'prénom');
                },
                'lastname' => function ($record, BridgeContent $bridge) {
                    return get_string_14py($record, 'nom');
                },
                'functions' => function ($record, BridgeContent $bridge) {
                    return get_entity_14py($record, $bridge, 'functions', 'fonction');
                },
                'phone' => function ($record, BridgeContent $bridge) {
                    return get_string_14py($record, 'sda');
                },
                'line' => function ($record, BridgeContent $bridge) {
                    return get_string_14py($record, 'ligne directe');
                },
                'mobile' => function ($record, BridgeContent $bridge) {
                    return get_string_14py($record, 'portable');
                },
                'services' => function ($record, BridgeContent $bridge) {
                    return get_entity_14py($record, $bridge, 'services', 'pole');
                },
                'floor' => function ($record, BridgeContent $bridge) {
                    return get_string_14py($record, 'etage');
                },
                'image' => function ($record, BridgeContent $bridge) {
                    $insideUser = \Inside\Content\Models\Contents\Users::query()->where('name', trim($record['mail']))->first();

                    /**
                     * If the user already has a picture set, return false.
                     * The image attribute will then be removed in the post_sync callback
                     */
                    if ($insideUser && !empty($insideUser->getAttribute('image'))) {
                        return false;
                    }

                    if (empty($record['photo utilisateur (.jpg)'])) {
                        return null;
                    }
                    $photo = trim($record['photo utilisateur (.jpg)']);
                    $imgPath = cms_base_path(env('APP_STORAGE_PATH', storage_path()).'/profile/'.$photo.'.jpg');
                    $chunkId = Str::random(32);
                    $chunksPath = cms_base_path(env('APP_STORAGE_PATH', storage_path()).'/chunks/'.$chunkId);

                    File::makeDirectory($chunksPath);

                    if (!File::isFile($imgPath) || !File::exists($imgPath)) {
                        return null;
                    }

                    $profileFilename = "{$photo}.jpg";

                    File::copy($imgPath, $chunksPath.'/'.$profileFilename);
                    return 'chunks/'.$chunkId.'/'.$profileFilename;
                },
                'colleague' => function ($record, BridgeContent $bridge) {
                    $uuids = [];

                    $lines = [
                        'travaille avec n°1 (email utilisateur)',
                        'travaille avec n°2 (email utilisateur)',
                    ];

                    foreach ($lines as $line) {
                        if (!empty($record[$line])) {
                            $user = \Inside\Content\Models\Contents\Users::query()->where('email', $record[$line])->first();

                            if ($user) {
                                $uuids[] = $user->uuid;
                            }
                        }
                    }

                    if (!empty($uuids)) {
                        return $uuids;
                    }

                    return null;
                },
                'status' => function ($record, BridgeContent $bridge) {
                    return 1;
                },
            ],
        ],
    ],
    'cleandata' => function (&$data) {
        if ($data['image'] === false) {
            unset($data['image']);
        }
    },
];
