<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContent;
use Inside\Layout\Models\Layout;
use Inside\Layout\Models\LayoutPath;

class SeedCustomPages extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContent();

        collect([
            ['title' => 'Annuaire', 'custom_slug' => 'directory', 'redirection_page' => 'DirectoryPage'],
            ['title' => 'Événements', 'custom_slug' => 'calendar', 'redirection_page' => 'EventsCalendarPage'],
            ['title' => 'GED Espace RH', 'custom_slug' => 'spaces-ged-page', 'redirection_page' => 'SpacesGedPage'],
            ['title' => 'Carte', 'custom_slug' => 'map', 'redirection_page' => 'MapPage'],
        ])->each(fn ($custom) => $bridge->contentInsert(type: 'custom', data: $custom, fromCli: true));

        LayoutPath::with('layout')
            ->where('path', 'not like', 'inside_content_forms.%')
            ->get()
            ->pluck('layout')
            ->each(fn (Layout $layout) => $layout->delete());
    }
}
