<?php

use Inside\Host\Migrations\CreateContentTypes;
use Inside\Notify\Migrations\ReportMigration;

class CreateReportDocumentsNotif extends ReportMigration
{
    use CreateContentTypes;

    public function up(): void
    {
        $output = $this->getConsole();

        $output->write("<info>Réinscription des administrateurs aux notifications de report.</info>");

        $type = 'documents';

        $this->registerReport(
            ['super_administrator'],
            $type,
            true,
            true,
            'CUSTOM:14py_ged'
        );

        $output->writeln(' <fg=green>✔</fg=green>');
    }

    public function down(): void
    {
    }
}
