<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddButtonColorFieldToSpacesLinks extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField('spaces_links', 'button_color', [
            'name' => 'color',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'default' => null,
            'required' => false,
            'weight' => 5,
            'title' => [
                'fr' => 'Couleur du bouton',
            ],
            'description' => [],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'group' => 'group_advanced_options',
            ],
            'type' => BridgeContentType::LIST_STRING_FIELD,
            'settings' => [
                'allowed_values' => [
                    'primary' => [
                        'fr' => 'Primaire'
                    ],
                    'secondary' => [
                        'fr' => 'Secondaire'
                    ]
                ],
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ], 5);
    }

    public function down(): void
    {
    }
}
